\name{dispersion_check}
\alias{dispersion_check}
\title{Effect estimates precision by sample size.}
\description{Provides an assessment of the distribution of estimates' precision vs. the study sample size.}
\usage{dispersion_check(script, sample_sizes = NULL, plot = TRUE)}
\arguments{
	\item{script}{
		Name of a textual input file with processing instructions. 
		The file should contain the names and locations of all GWAS data files to be processed 
		along with basic information from each individual study, and instructions for the quality check.
	}
	\item{sample_sizes}{A vector with all study sample sizes.}
	\item{plot}{Logical value indicating if the diagnostic plot should be produced.}
}
\details{
	The function uses \emph{CSV} reports generated by \code{gwasqc()} function.
	As input it requires the same script as \code{gwasqc()} function and assumes that all the reports are in the current working directory.
	If the study sample size is missing from GWAS files, then the function has an optional parameter allowing to specify a vector with all study sample sizes.
	The function returns a data frame with the information extracted from the \emph{CSV} reports and produces the diagnostic plot.	
}
\author{Cristian Pattaro, Daniel Taliun, Christian Fuchsberger}
\keyword{misc}
\keyword{utilities}
\keyword{package}
\examples{
	\dontshow{
	# change the workspace
	currentWd <- getwd()
	newWd <- paste(system.file(package="GWAtoolbox"), "doc", sep="/")
	setwd(newWd)
	}

	# name of an input script
	script <- "GWASQC_script.txt"

	# load GWAtoolbox library
	library(GWAtoolbox)

	# show contents of the input script
	file.show(script, title=script)

	\dontshow{options(device.ask.default = FALSE)}

	# run gwasqc() function
	gwasqc(script)
	
	# run dispersion_check() function
	Z <- dispersion_check("GWASQC_script.txt", plot=TRUE)
	text(Z$median_n, Z$mean_se, labels=Z$study, pos=c(2,4,2,1,2))

	\dontshow{
	# restore previous workspace
	setwd(currentWd)
	}
	
    \dontshow{
	# all input and output files are located in the subdirectory "doc" of the installed GWAtoolbox package
	message <- c("\n", rep("#", 40), "\n")
	message <- c(message, "\nAll input and output files of this example are located in directory:\n", newWd, "\n")
	message <- c(message, "\n", rep("#", 40),"\n")
	cat(message, sep="")
	}
}