\name{create_browser_track}
\alias{create_browser_track}
\title{BED file generation for UCSC and Ensembl genome browsers.}
\description{
	Function transforms \code{\link{mig}} ouptut file with haplotype blocks into BED format.
	The BED format allows to visualize haplotype blocks in UCSC and Ensembl genome browsers.
	The blocks are colored based on haplotype diversity within them: higher red color intensity corresponds to the lower diversity.	
}
\usage{
	create_browser_track(input_file, output_file, chromosome, strand, track_name = "", track_desc = "")
}
\arguments{
	\item{input_file}{
		The name of the input file with haplotype blocks generated by \code{\link{mig}}.
	}
	\item{outpu_file}{
		The name of the output BED file.
	}
	\item{chromosome}{
		The chromosome name (e.g. chr3, chrY, chr2_random).
	}
	\item{strand}{ 
		The strand: "+" or "-".
	}
	\item{track_name}{
		The name of the track, which will be depicted in genome browser.
	}
	\item{track_desc}{
		The short description of the track.
	}
}
\author{Daniel Taliun, Johann Gamper, Cristian Pattaro}
\keyword{misc}
\keyword{utilities}
\keyword{package}