/*
 * Copyright  2014 Daniel Taliun, Johann Gamper and Cristian Pattaro. All rights reserved.
 *
 * This file is part of S-MIG++.
 *
 * S-MIG++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * S-MIG++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with S-MIG++. If not, see <http://www.gnu.org/licenses/>.
 */

#include "include/AlgorithmFactory.h"

const char* AlgorithmFactory::NONE = "NONE";
const char* AlgorithmFactory::WP = "WP";
const char* AlgorithmFactory::AV = "AV";

AlgorithmFactory::AlgorithmFactory() {

}

AlgorithmFactory::~AlgorithmFactory() {

}

AlgorithmCI* AlgorithmFactory::create(Db& db, const char* method) throw (Exception) {
	if (auxiliary::strcmp_ignore_case(method, NONE) == 0) {
		return new AlgorithmCI(db);
	} else if (auxiliary::strcmp_ignore_case(method, WP) == 0) {
		return new Bayesian(db);
	} else if (auxiliary::strcmp_ignore_case(method, AV) == 0) {
		return new Zapata(db);
	} else {
		throw Exception(__FILE__, __LINE__, "Unknown CI computation method '%s' was specified.", method);
	}
}
