/*
 * Copyright  2014 Daniel Taliun, Johann Gamper and Cristian Pattaro. All rights reserved.
 *
 * This file is part of S-MIG++.
 *
 * S-MIG++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * S-MIG++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with S-MIG++. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ALGORITHMFACTORY_H_
#define ALGORITHMFACTORY_H_

#include "../../exception/include/Exception.h"
#include "../../db/include/Db.h"
#include "AlgorithmCI.h"
#include "Bayesian.h"
#include "Zapata.h"

class AlgorithmFactory {
public:
	static const char* NONE;
	static const char* WP;
	static const char* AV;

	AlgorithmFactory();
	virtual ~AlgorithmFactory();

	static AlgorithmCI* create(Db& db, const char* method) throw (Exception);
};

#endif
