/*
 * Copyright  2014 Daniel Taliun, Johann Gamper and Cristian Pattaro. All rights reserved.
 *
 * This file is part of S-MIG++.
 *
 * S-MIG++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * S-MIG++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with S-MIG++. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CONTOURBUILDER_H_
#define CONTOURBUILDER_H_

#include <iostream>
#include <unordered_map>
#include <limits>
#include <cmath>
#include <algorithm>

#include "../../exception/include/Exception.h"
#include "../../db/include/Db.h"
#include "Cell.h"
#include "Profile.h"
#include "AlgorithmFactory.h"
#include "ProfileFactory_FS.h"

#include "gsl/gsl_errno.h"
#include "gsl/gsl_cdf.h"
#include "gsl/gsl_math.h"
#include "gsl/gsl_rng.h"

using namespace std;

class ContourBuilder {
private:
	static const double EPSILON;

	struct Segment {
		unsigned int start;
		unsigned int end;
	};

	Db* db;
	const char* ci_method;
	const char* sci_method;
	double alpha;
	double samples;
	double proportion;
	unsigned int n_segments;

	ProfileFactory* profile_factory;

	unsigned long int seed;
	unsigned long int n_cells;

	unsigned int segment_i;
	unsigned int segment_j;

	unsigned long int n_computations;
	unsigned long int n_candidate_profiles;

	unsigned int* estimated_contour;

	Segment* segments;

	unsigned long int max_pool_size;

	void generate_segments() throw (Exception);
	Cell* generate_next_cell();

	void add_profile(Profile* profile);

public:
	ContourBuilder(Db& db, const char* ci_method, const char* sci_method, double probability, double proportion, double samples, unsigned int n_segments, bool adjust, unsigned long int seed) throw (Exception);

	virtual ~ContourBuilder();

	unsigned int get_n_segments();
	unsigned int get_n_cells();
	unsigned long int get_seed();
	double get_alpha();
	unsigned long int get_n_computations();
	unsigned long int get_n_candidate_profiles();
	unsigned long int get_estimated_contour_area();
	unsigned int* get_estimated_contour();

	void build() throw (Exception);

	double get_memory_usage();

};

#endif
