/*
 * Copyright  2014 Daniel Taliun, Johann Gamper and Cristian Pattaro. All rights reserved.
 *
 * This file is part of S-MIG++.
 *
 * S-MIG++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * S-MIG++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with S-MIG++. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PROFILE_H_
#define PROFILE_H_

#include "../../exception/include/Exception.h"
#include "../../writer/include/WriterFactory.h"
#include "Cell.h"

#include "gsl/gsl_errno.h"
#include "gsl/gsl_cdf.h"
#include "gsl/gsl_math.h"
#include "gsl/gsl_rng.h"
#include "gsl/gsl_randist.h"
#include "gsl/gsl_sf_gamma.h"

class Profile {
protected:
	static const double EPSILON;

	static double alpha;
	static double chisq_2df;
	static double z_gaussian;

	int n_references;

	unsigned int segment_i;
	unsigned int segment_j;

	unsigned int start;
	unsigned int end;

	unsigned long int n_total;
	unsigned long int n_sampled_noninf;
	unsigned long int n_sampled_ld;
	unsigned long int n_sampled_ehr;

	double min_n_ehr;

	double upper_ld;
	double lower_ehr;
	double pi;

	virtual void estimate_simultaneous_ci() = 0;

public:
	Profile(Cell* cell, Profile* west, Profile* south_west, Profile* south);

	virtual ~Profile();

	static void set_alpha(double alpha) throw (Exception);
	void set_n_references(int n_references);

	void remove_reference();

	int get_n_references();
	unsigned int get_start();
	unsigned int get_end();
	double get_pi();

	void estimate_ld_proportion();

	void write(Writer* writer) throw (Exception);
};

#endif
