/*
 * Copyright  2014 Daniel Taliun, Johann Gamper and Cristian Pattaro. All rights reserved.
 *
 * This file is part of S-MIG++.
 *
 * S-MIG++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * S-MIG++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with S-MIG++. If not, see <http://www.gnu.org/licenses/>.
 */

#include "include/Profile_FS.h"

Profile_FS::Profile_FS(Cell* cell, Profile* west, Profile* south_west, Profile* south) :
	Profile(cell, west, south_west, south),
	n_sampled_total(0.0), p_ld(0.0), p_ehr(0.0), half_interval(0.0) {

}

Profile_FS::~Profile_FS() {

}

void Profile_FS::estimate_simultaneous_ci() {
	n_sampled_total = (double)(n_sampled_ld + n_sampled_ehr + n_sampled_noninf);
	p_ld = n_sampled_ld / n_sampled_total;
	p_ehr = n_sampled_ehr / n_sampled_total;

	half_interval = z_gaussian / (2.0 * sqrt(n_sampled_total));

	upper_ld = p_ld + half_interval;
	if (upper_ld > 1.0) {
		upper_ld = 1.0;
	}

	lower_ehr = p_ehr - half_interval;
	if (lower_ehr < 0.0) {
		lower_ehr = 0.0;
	}
}

