/*
 * Copyright  2014 Daniel Taliun, Johann Gamper and Cristian Pattaro. All rights reserved.
 *
 * This file is part of S-MIG++.
 *
 * S-MIG++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * S-MIG++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with S-MIG++. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CELL_H_
#define CELL_H_

#include "../../exception/include/Exception.h"
#include "AlgorithmFactory.h"

#include "gsl/gsl_errno.h"
#include "gsl/gsl_cdf.h"
#include "gsl/gsl_math.h"
#include "gsl/gsl_rng.h"
#include "gsl/gsl_randist.h"

using namespace std;

class Cell {
private:
	static const double EPSILON;

	static Db* db;
	static const char* method;
	static double samples;
	static unsigned long int seed;

	unsigned int segment_i;
	unsigned int segment_j;

	unsigned int start_i;
	unsigned int end_i;
	unsigned int start_j;
	unsigned int end_j;

	unsigned long int n_sampled_noninf;
	unsigned long int n_sampled_ld;
	unsigned long int n_sampled_ehr;

public:
	Cell(unsigned int segment_i, unsigned int segment_j, unsigned int start_i, unsigned int end_i, unsigned start_j, unsigned int end_j);

	virtual ~Cell();

	static void set_db(Db* db);
	static void set_method(const char* method);
	static void set_samples(double samples);
	static void set_seed(unsigned long int seed);

	void get_coordinates(unsigned int* segment_i, unsigned int* segment_j);
	unsigned int get_segment_i();
	unsigned int get_segment_j();
	unsigned int get_start_i();
	unsigned int get_end_i();
	unsigned int get_start_j();
	unsigned int get_end_j();
	unsigned long int get_n_total();
	unsigned long int get_n_sampled_noninf();
	unsigned long int get_n_sampled_ld();
	unsigned long int get_n_sampled_ehr();

	unsigned long int sample() throw (Exception);

	void write(Writer* writer) throw (Exception);

	friend class ContourBuilder;
};

#endif
