/*
 * Copyright  2014 Daniel Taliun, Johann Gamper and Cristian Pattaro. All rights reserved.
 *
 * This file is part of S-MIG++.
 *
 * S-MIG++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * S-MIG++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with S-MIG++. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MIG_H_
#define MIG_H_

#include <map>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <deque>

#include "../../auxiliary/include/auxiliary.h"
#include "../../db/include/Db.h"
#include "AlgorithmFactory.h"
#include "../../writer/include/WriterFactory.h"

using namespace std;

class MIG {
private:
	static const unsigned int STRONG_PAIRS_SIZE_INIT;
	static const unsigned int STRONG_PAIRS_SIZE_INCREMENT;
	static const unsigned int BLOCKS_SIZE_INIT;
	static const unsigned int BLOCKS_SIZE_INCREMENT;

	struct interval {
		unsigned int start;
		unsigned int end;
	};

	struct pair {
		unsigned int first;
		unsigned int last;
		unsigned long int distance;
	};

	Db* db;
	pair* strong_pairs;
	unsigned int n_strong_pairs;
	unsigned int strong_pairs_size;
	unsigned int* blocks;
	unsigned int n_blocks;
	unsigned int blocks_size;

	long double* w_values_random;
	unsigned int* w_values_random_n;

	bool is_compatible_haplotype(const char* first, const char* second);
	void get_block_diversity(unsigned int block_id,
			unsigned int* n_haps, unsigned int* n_unique_haps, unsigned int* n_common_haps, double* haps_diversity) throw (Exception);

	static int paircmp(const void* first, const void* second);

public:
	static const double EPSILON;

	MIG(Db& db) throw (Exception);
	virtual ~MIG();

	unsigned long int compute_candidate_blocks_migpp(unsigned int* contour, const char* ci_method, unsigned int threshold) throw (Exception);

	void sort_candidate_blocks();
	void select_final_blocks() throw (Exception);

	void get_contour(unsigned int** contour, unsigned long int* contour_area) throw (Exception);
	void write_contour(unsigned int* contour, const char* output_file_name, const char* output_type) throw (Exception);

	unsigned int get_n_strong_pairs();
	unsigned int get_n_blocks();

	void write_blocks(const char* output_file_name, const char* output_type, const char* input_phase_file_name, const char* input_map_file_name,
			double maf_threshold, bool region, unsigned long int start, unsigned long int end, const char* ci_method) throw (Exception);

	void write_candidate_blocks(const char* output_file_name, const char* output_type) throw (Exception);

	long double get_proportion(Db* db, const char* ci_method, unsigned int start_i, unsigned int end_i, unsigned int start_j, unsigned int end_j) throw (Exception);

	double get_max_memory_usage();
};

#endif
