/*
 * Copyright  2014 Daniel Taliun, Johann Gamper and Cristian Pattaro. All rights reserved.
 *
 * This file is part of S-MIG++.
 *
 * S-MIG++ is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * S-MIG++ is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with S-MIG++. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PROFILE_FS_H_
#define PROFILE_FS_H_

#include "Profile.h"

class Profile_FS: public Profile {
private:
	double n_sampled_total;
	double p_ld;
	double p_ehr;
	double half_interval;

	// Fitzpatrick and Scott (1987)
	void estimate_simultaneous_ci();

public:
	Profile_FS(Cell* cell, Profile* west, Profile* south_west, Profile* south);
	virtual ~Profile_FS();
};

#endif
